/*
 * Decompiled with CFR 0.152.
 */
package pse.model;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.w3c.dom.Node;
import pse.assessment.PantherAssessment;
import pse.assessment.PantherAssessments;
import pse.assessment.PantherForm;
import pse.assessment.PantherTask;
import pse.assessment.PantherTasks;
import pse.model.ModelObject;
import pse.result.Result;
import pse.util.general.XmlUtils;

public class ModelUtils {
    public static PantherForm getFormFromTopLevelXml(File file) throws Exception {
        PantherForm pantherForm = null;
        ModelObject modelObject = ModelUtils.readTopLevelXml(file);
        if (modelObject instanceof PantherAssessments) {
            PantherAssessments pantherAssessments = (PantherAssessments)modelObject;
            PantherAssessment pantherAssessment = pantherAssessments.getFirstAssessment();
            pantherForm = pantherAssessment.getFirstForm();
        } else if (modelObject instanceof PantherAssessment) {
            PantherAssessment pantherAssessment = (PantherAssessment)modelObject;
            pantherForm = pantherAssessment.getFirstForm();
        } else if (modelObject instanceof PantherForm) {
            pantherForm = (PantherForm)modelObject;
        }
        if (pantherForm == null) {
            throw new Error("No form could be found in input file " + file.getCanonicalPath());
        }
        return pantherForm;
    }

    public static PantherTask getTaskFromTopLevelXml(File file, String string) throws Exception {
        PantherTask pantherTask = null;
        ModelObject modelObject = ModelUtils.readTopLevelXml(file);
        if (modelObject instanceof PantherTasks) {
            PantherTasks pantherTasks = (PantherTasks)modelObject;
            pantherTask = string == null ? pantherTasks.getFirstTask() : pantherTasks.getTask(string);
        } else if (modelObject instanceof PantherTask) {
            PantherTask pantherTask2 = (PantherTask)modelObject;
            if (string == null || pantherTask2.getVdsIdent().equals(string)) {
                pantherTask = pantherTask2;
            }
        }
        if (pantherTask == null) {
            throw new Error("No task matching task ident " + string + " could be found in input file " + file.getCanonicalPath());
        }
        return pantherTask;
    }

    public static ModelObject readTopLevelXml(File file) throws Exception {
        Node node = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            node = XmlUtils.parseToNode(file.getCanonicalPath(), fileReader);
        }
        catch (Throwable throwable) {
            throw new Error("Unable to parse task file " + file.getCanonicalPath(), throwable);
        }
        finally {
            if (fileReader != null) {
                ((Reader)fileReader).close();
            }
        }
        ModelObject modelObject = null;
        String string = node.getNodeName();
        if (string.equals("assessment")) {
            modelObject = new PantherAssessment();
        } else if (string.equals("panther-assessments")) {
            modelObject = new PantherAssessments();
        } else if (string.equals("panther-result")) {
            modelObject = new Result();
        } else if (string.equals("panther-task")) {
            modelObject = new PantherTask();
        } else if (string.equals("panther-tasks")) {
            modelObject = new PantherTasks();
        } else {
            throw new Error("The tag <" + string + "> isn't recognized as a top-level Panther tag name.");
        }
        try {
            modelObject.fromMyNode(node);
        }
        catch (Throwable throwable) {
            throw new Error("Unable to create a valid Panther Model object from input file " + file.getCanonicalPath(), throwable);
        }
        return modelObject;
    }
}

